package fp;

/**
 * Defines a lambda that is mapped over a set of objects 
 * of type H as defined by IMapHost.
 * P is the type of an arbitrary input parameter that 
 * is handed to the lambda on every application on the 
 * elements of set.
 */
public interface IMapAlgo<H,P> {
  /**
   * Called on every element of the set.
   * @param host The given element of the set
   * @param inp An arbitrary input parameter
   * @return The mapping will continue when true or terminate immediately if false.
   */
  public abstract boolean apply(H host, P... inp);
  
  /**
   * Called when the set is empty and the lambda cannot be applied.
   * @param inp An arbitrary input parameter
   */
  public abstract void noApply(P... inp);
}